<?php
session_start();
require '../conexao.php'; // Inclui o arquivo de conexão

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Verifica se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$jogador = $_SESSION['user_id'];
$user_name = $_SESSION['user_name'];

// Verifica se o formulário foi enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $quantidade = (int)$_POST['quantidade'];
    $preco = (float)$_POST['preco'];

    // Validação básica
    if ($quantidade <= 0 || $preco <= 0) {
        $_SESSION['msg'] = "Por favor, preencha todos os campos corretamente.";
        header("Location: vender_fichas.php");
        exit();
    }

    // Verifica se o jogador tem fichas suficientes
    try {
        $pdo->beginTransaction();

        // Conta as fichas disponíveis do jogador (situacao = '1')
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM fichaspersonagens WHERE jogador = ? AND situacao = '1'");
        $stmt->execute([$user_name]);
        $fichas_disponiveis = $stmt->fetchColumn();

        error_log("Fichas disponíveis para $user_name: $fichas_disponiveis");

        if ($fichas_disponiveis < $quantidade) {
            $_SESSION['msg'] = "Fichas insuficientes. Você tem $fichas_disponiveis fichas disponíveis e tentou vender $quantidade.";
            header("Location: vender_fichas.php");
            exit();
        }

        // Insere a venda na tabela vendadefichas
        $stmt = $pdo->prepare("INSERT INTO vendadefichas (quantidade, jogador, preco, datacriacao) VALUES (?, ?, ?, NOW())");
        $stmt->execute([$quantidade, $jogador, $preco]);



try {
    $jogadorx = $user_name; // Substitua pelo valor correto
    $quantidade = $quantidade; // Substitua pelo valor correto

     $sql = "UPDATE fichaspersonagens SET situacao = 'vendendo', preco = ? WHERE jogador = ? AND situacao = '1' LIMIT ?";
    $stmt = $pdo->prepare($sql);

    // Passa os valores para a consulta
    $stmt->bindValue(1, $preco, PDO::PARAM_STR); // Preço
    $stmt->bindValue(2, $jogadorx, PDO::PARAM_STR); // Jogador
    $stmt->bindValue(3, $quantidade, PDO::PARAM_INT); // Quantidade

 // Executa a consulta
    $stmt->execute(); // <--- AQUI ESTÁ O execute() QUE FALTAVA

    echo "Atualização realizada com sucesso!";
} catch (PDOException $e) {
    echo "Erro: " . $e->getMessage();
}


        // Atualiza a situação das fichas para 'vendendo'
        $sql = "UPDATE fichaspersonagens SET situacao = 'vendendo', preco = ? WHERE jogador = ? AND situacao = '1' LIMIT ?";
        error_log("Executando SQL: $sql");
        error_log("Jogador: $jogador, Quantidade: $quantidade");

        $stmt = $pdo->prepare($sql);
         $stmt->bindValue(1, $preco, PDO::PARAM_STR); // Preço
    $stmt->bindValue(2, $jogadorx, PDO::PARAM_STR); // Jogador
    $stmt->bindValue(3, $quantidade, PDO::PARAM_INT); // Quantidade
        $stmt->execute();

        $pdo->commit();

        $_SESSION['msg'] = "Venda de $quantidade fichas por R$ $preco cadastrada com sucesso!";
        header("Location: vender_fichas.php");
        exit();
    } catch (PDOException $e) {
        $pdo->rollBack();
        error_log("Erro ao processar a venda: " . $e->getMessage());
        $_SESSION['msg'] = "Erro ao processar a venda: " . $e->getMessage();
        header("Location: vender_fichas.php");
        exit();
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Vender Fichas</title>
    <link rel="stylesheet" type="text/css" href="../style.css">
    <script>
        function formatCurrency(input) {
            // Remove todos os caracteres não numéricos
            let value = input.value.replace(/\D/g, '');

            // Garante que o valor tenha pelo menos 2 dígitos (para os centavos)
            if (value.length === 0) {
                value = '000'; // Inicia com "0.00"
            } else if (value.length === 1) {
                value = '00' + value; // Adiciona dois zeros à esquerda
            } else if (value.length === 2) {
                value = '0' + value; // Adiciona um zero à esquerda
            }

            // Separa a parte inteira dos centavos
            const integerPart = value.slice(0, -2); // Parte inteira
            const decimalPart = value.slice(-2); // Centavos

            // Formata o valor como "X.XX" ou "XX.XX", etc.
            input.value = `${integerPart}.${decimalPart}`;
        }

        function confirmarVenda() {
            return confirm("Tem certeza que deseja vender essas fichas?");
        }
    </script>
</head>
<body>
    <div class="titulo">Vender Fichas</div>
    <center>
        <?php
        if (isset($_SESSION['msg'])) {
            echo '<p class="mensagem">' . $_SESSION['msg'] . '</p>';
            unset($_SESSION['msg']);
        }
        ?>
    </center>
    <form method="POST" onsubmit="return confirmarVenda()">
        <input type="number" class="inputpadrao" id="quantidade" name="quantidade" placeholder="Quantidade de Fichas" required min="1">
        <br><br>
        <input type="text" class="inputpadrao" id="preco" name="preco" placeholder="Preço (ex: 0.00)" required oninput="formatCurrency(this)">
        <br><br>
        <button type="submit" class="btn">Vender Fichas</button>
    </form>
</body>
</html>